/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.hive;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CupidBee
extends ProductiveBee {
    public Animal targetEntity = null;
    private int animalsBredSincePollination;
    private SetLoveModeGoal loveGoal;
    public static Predicate<Entity> predicate = entity -> {
        if (entity instanceof Animal) {
            return !((Animal)entity).m_27593_() && !((Animal)entity).m_6162_();
        }
        return false;
    };

    public CupidBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.beeAttributes.put(BeeAttributes.WEATHER_TOLERANCE, 1);
    }

    @Override
    public boolean canSelfBreed() {
        return false;
    }

    @Override
    protected void m_8099_() {
        this.registerBaseGoals();
        this.f_21345_.m_25363_((Goal)this.breedGoal);
        this.f_27699_ = new ProductiveBee.PollinateGoal(this);
        this.f_21345_.m_25352_(4, (Goal)this.f_27699_);
        this.f_27701_ = new Bee.BeeGoToKnownFlowerGoal((Bee)this);
        this.f_21345_.m_25352_(6, (Goal)this.f_27701_);
        this.f_21345_.m_25352_(2, (Goal)new GoToBreedableGoal());
        this.loveGoal = new SetLoveModeGoal();
        this.f_21345_.m_25352_(3, (Goal)this.loveGoal);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData livingEntityData, @Nullable CompoundTag tag) {
        if (ProductiveBees.rand.nextFloat() < 0.01f) {
            this.m_6593_((Component)new TextComponent("Lena CuBee"));
        }
        return super.m_6518_(world, difficulty, spawnReason, livingEntityData, tag);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 == 0 && this.m_27856_()) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    private int getAnimalsBredSincePollination() {
        return this.animalsBredSincePollination;
    }

    private void resetBreedCounter() {
        this.animalsBredSincePollination = 0;
    }

    private void addBreedCounter() {
        ++this.animalsBredSincePollination;
    }

    @Override
    public boolean m_27866_() {
        return super.m_27866_() && !this.loveGoal.isRunning();
    }

    public void m_27864_() {
        super.m_27864_();
        this.resetBreedCounter();
    }

    public List<Entity> findNearbyBreedables(float distance) {
        BlockPos pos = this.m_142538_();
        return this.f_19853_.m_6249_((Entity)this, new AABB(pos).m_82377_((double)distance, (double)distance, (double)distance), predicate);
    }

    public class GoToBreedableGoal
    extends Goal {
        private int ticks = 0;

        public boolean m_8036_() {
            return !CupidBee.this.m_21660_() && CupidBee.this.m_27856_() && CupidBee.this.targetEntity != null;
        }

        public boolean m_8045_() {
            return CupidBee.this.targetEntity != null && CupidBee.this.targetEntity.m_20182_().m_82554_(CupidBee.this.targetEntity.m_20182_()) > 2.0;
        }

        public void m_8056_() {
            this.ticks = 0;
        }

        public void m_8037_() {
            if (CupidBee.this.targetEntity != null) {
                ++this.ticks;
                if (this.ticks > 600) {
                    CupidBee.this.targetEntity = null;
                } else if (!CupidBee.this.f_21344_.m_26571_() || this.ticks % 100 == 0) {
                    BlockPos blockPos = CupidBee.this.targetEntity.m_142538_();
                    CupidBee.this.f_21344_.m_26519_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 1.0);
                }
            }
        }
    }

    public class SetLoveModeGoal
    extends Goal {
        private int ticks = 0;
        private boolean running;

        public boolean m_8036_() {
            List<Entity> breedablesNearby;
            if (!CupidBee.this.m_21660_() && CupidBee.this.m_27856_() && CupidBee.this.getAnimalsBredSincePollination() <= (Integer)ProductiveBeesConfig.BEES.cupidBeeAnimalsPerPollination.get() && !(breedablesNearby = CupidBee.this.findNearbyBreedables(5.0f)).isEmpty() && breedablesNearby.size() < (Integer)ProductiveBeesConfig.BEES.cupidBeeAnimalDensity.get()) {
                BlockPos beePos = CupidBee.this.m_142538_();
                Animal nearest = null;
                double nearestDistance = 0.0;
                for (Entity entity : breedablesNearby) {
                    if (!(entity instanceof Animal)) continue;
                    BlockPos pos = entity.m_142538_();
                    double distance = pos.m_123331_((Vec3i)beePos);
                    if (nearestDistance != 0.0 && !(distance < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearest = (Animal)entity;
                }
                CupidBee.this.targetEntity = nearest;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (!this.running) {
                return false;
            }
            return CupidBee.this.targetEntity != null && CupidBee.this.m_27856_() && !CupidBee.this.m_21660_();
        }

        public boolean isRunning() {
            return this.running;
        }

        public void m_8056_() {
            this.ticks = 0;
            this.running = true;
        }

        public void m_8041_() {
            this.running = false;
        }

        public void m_8037_() {
            ++this.ticks;
            if (CupidBee.this.targetEntity != null) {
                if (this.ticks > 600) {
                    CupidBee.this.targetEntity = null;
                } else {
                    Vec3 vec3d = CupidBee.this.targetEntity.m_20182_().m_82520_(0.5, (double)0.6f, 0.5);
                    double distanceToTarget = vec3d.m_82554_(CupidBee.this.m_20182_());
                    if (distanceToTarget > 1.0) {
                        this.moveToNextTarget(vec3d);
                    } else if (distanceToTarget > 0.1 && this.ticks > 600) {
                        CupidBee.this.targetEntity = null;
                    } else {
                        Entity target;
                        List<Entity> breedablesNearby = CupidBee.this.findNearbyBreedables(1.0f);
                        if (!breedablesNearby.isEmpty() && (target = breedablesNearby.iterator().next()) instanceof Animal) {
                            if (!((Animal)target).m_6162_() && ((Animal)target).m_5957_()) {
                                ((Animal)target).m_27595_(null);
                                CupidBee.this.addBreedCounter();
                            }
                            CupidBee.this.m_5496_(SoundEvents.f_11693_, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }

        private void moveToNextTarget(Vec3 target) {
            CupidBee.this.m_21566_().m_6849_(target.f_82479_, target.f_82480_, target.f_82481_, 1.0);
        }
    }
}

